<%--
 This JSP is responsible for submitting client information that we might
 find useful on the server.  The information is as follows:

  1. Available screen width, the value of the JavaScript Screen.availWidth property.
  2. Available screen height, the value of the JavaScript Screen.availHeight property.
  3. A sample of the client's Date.toString() output, to help the server deduce
     what time zone the client is running in.
  4. A flag indicating whether or not the client appears to observe
     daylight-saving-time rules.

 The "Connect" servlet dispatches to this page when the user is starting a new
 session with the HMC, but we have not retrieved client information yet.

 For determining whether or not the client appears to observe
 daylight-saving-time rules, we ask the browser what timezone offset would be
 used now, 3 months from now, 6 months from now, and 9 months from now.  If
 the current offset is different from any of those, we assume the client
 observes daylight-saving-time rules.  This should be a safe test for most
 locales.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect">
<html>
<head>
   <hmc:title><fmt:message key="fetchingwindowtitle"/></hmc:title>
   <meta http-equiv="Cache-Control" content="no-cache">
</head>
<body>
<fmt:message key="sendingClientInfo"/>

<script type="text/javascript">
   var now = new Date();
   var tzNow = now.getTimezoneOffset();
   var tz3months = new Date(now.getTime()+7889400000).getTimezoneOffset();    // 3 months from now
   var tz6months = new Date(now.getTime()+15778800000).getTimezoneOffset();   // 6 months from now
   var tz9months = new Date(now.getTime()+23668200000).getTimezoneOffset();   // 9 months from now
   var usesDST = tzNow != tz3months || tzNow != tz6months || tzNow != tz9months;

   window.location.replace("/hmc/connect?<c:out value='${reqparms}' escapeXml='false'/>availableScreenSize="+
                           screen.availWidth+","+screen.availHeight+
                           "&tzOffset="+tzNow+
                           "&time="+now.getTime()+
                           "&timeString="+encodeURIComponent(now.toTimeString())+
                           "&usesDST="+usesDST);
</script>

</body>
</html>
</fmt:bundle>
